using System;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.IO;
using System.Text;
using System.Xml;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;

namespace gov.va.med.vbecs.DAL.VAL.RPC
{	
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Stas Antropov</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>2/27/2005</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///		This class is used by the VistALink Windows Service TCP/IP Listener to collect 
	///		and return VBECS workload data to to the VistA Lab package to report various 
	///		workload events and to update the VBECS database when the workload has been reported by Lab.
	///</summary>

	#endregion

	public class Workload : MarshalByRefObject
	{
		private const string PENDING_TRANSMISSION_STATUS = "P";
		private const string IN_PROCESS_STATUS = "I";
		private const string SUCCESSFUL_STATUS = "S";
		private const string ERROR_STATUS = "E";
		private const string XMLCONST_WORKLOADEVENTS_NODE_NAME = "WorkloadEvents";
		private const string XMLCONST_WORKLOADEVENT_NODE_NAME = "WorkloadEvent";
		private const string XMLCONST_ERRORTEXT_NODE_NAME = "ErrorText";
		private const string XMLCONST_WORKLOADEVENT_ID_ATT_NAME = "id";
		private const string XMLCONST_WORKLOADEVENT_SUCCESS_ATT_NAME = "successfullyUpdated";

		///<Developers>
		///	<Developer>Brian Tomlin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/8/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4091"> 
		///		<ExpectedInput>statusCode = "P"</ExpectedInput>
		///		<ExpectedOutput>xml string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4092"> 
		///		<ExpectedInput>empty string statusCode</ExpectedInput>
		///		<ExpectedOutput>ArgumentException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets pending workload data.
		/// </summary>
		/// <param name="statusCode">Status code.</param>
		/// <returns>Pending workload data XML.</returns>
		public string GetPendingWorkloadData(string statusCode)
		{
			if( statusCode != PENDING_TRANSMISSION_STATUS )
				throw( new ArgumentException( "Invalid WorkloadEventStatusCode", "statusCode" ) );

			SqlParameter[] prms =
					{
						new SqlParameter(STOREDPROC.VistaGetXmlWorkloadData.WorkloadEventStatusCode, SqlDbType.Char)
					};
			
			prms[0].Value = statusCode;

			return RpcDataReader.GetXmlData(STOREDPROC.VistaGetXmlWorkloadData.StoredProcName, prms);
		}

		///<Developers>
		///	<Developer>Brian Tomlin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/9/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5521"> 
		///		<ExpectedInput>Valid input data</ExpectedInput>
		///		<ExpectedOutput>xml string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5522"> 
		///		<ExpectedInput>Invalid wkldEventGuid</ExpectedInput>
		///		<ExpectedOutput>ArgumentException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Updates workload event.
		/// </summary>
		/// <param name="wkldEventGuid">Workload event GUID.</param>
		/// <param name="wkldEventStatus">Workload event status.</param>
		/// <param name="processedDate">Processed date.</param>
		/// <param name="errorText">Error text.</param>
		/// <param name="pceEncounterNumber">Pre-encounter number.</param>
		/// <returns>Result of update.</returns>
		public string UpdateWorkloadEvent(string wkldEventGuid,
											string wkldEventStatus,
											string processedDate,
											string errorText,
											string pceEncounterNumber)
		{
			if( wkldEventGuid == "" )
				throw( new ArgumentNullException( "wkldEventGuid" ) );
			if( wkldEventStatus == "" )
				throw( new ArgumentNullException( "wkldEventStatus" ) );
			if( processedDate == "" )
				throw( new ArgumentNullException( "processedDate" ) );
			if( errorText == "" )
				errorText = null;
			if( pceEncounterNumber == "" )
				pceEncounterNumber = null;

			string results;
			
			try
			{
				SqlParameter[] prms =
					{
						new SqlParameter(STOREDPROC.VistaUpdateWorkloadEventData.WorkloadEventGuid, SqlDbType.VarChar),
						new SqlParameter(STOREDPROC.VistaUpdateWorkloadEventData.WorkloadEventStatusCode, SqlDbType.Char),
						new SqlParameter(STOREDPROC.VistaUpdateWorkloadEventData.ProcessedDate, SqlDbType.VarChar),
						new SqlParameter(STOREDPROC.VistaUpdateWorkloadEventData.ErrorText, SqlDbType.VarChar),
						new SqlParameter(STOREDPROC.VistaUpdateWorkloadEventData.PceEncounterNumber, SqlDbType.VarChar)
					};

				prms[0].Value = wkldEventGuid;
				prms[1].Value = Convert.ToChar(wkldEventStatus.ToUpper());
				prms[2].Value = processedDate;
				prms[3].Value = errorText;
				prms[4].Value = pceEncounterNumber;

				results = RpcDataReader.GetXmlData(STOREDPROC.VistaUpdateWorkloadEventData.StoredProcName, prms);
			}
			catch(Exception exc)
			{
				return BuildUpdateReturnXml( wkldEventGuid, "0", exc.Message );
			}
			
			return BuildUpdateReturnXml( wkldEventGuid, "1", "" );

		}

		private static string BuildUpdateReturnXml(string id, string success, string errorText)
		{
			MemoryStream _stream = new MemoryStream();
			XmlTextWriter xwriter = new XmlTextWriter( _stream, Encoding.UTF8 );
			xwriter.WriteStartDocument();

			xwriter.WriteStartElement(XMLCONST_WORKLOADEVENTS_NODE_NAME);
			xwriter.WriteStartElement(XMLCONST_WORKLOADEVENT_NODE_NAME);
			xwriter.WriteAttributeString(XMLCONST_WORKLOADEVENT_ID_ATT_NAME,id);
			xwriter.WriteAttributeString(XMLCONST_WORKLOADEVENT_SUCCESS_ATT_NAME, success);
			xwriter.WriteElementString(XMLCONST_ERRORTEXT_NODE_NAME, errorText);
			xwriter.WriteEndElement();
			xwriter.WriteEndDocument();
			xwriter.Flush();

			StringBuilder sb = new StringBuilder();
			sb.Append( System.Text.Encoding.ASCII.GetChars( _stream.ToArray() ) );
			if( sb.ToString().Substring(0,3) == "???" )
			{
				sb.Remove(0, 3);
			}

			return sb.ToString();
		}
	}
}
